// The constructor function: creates a Cookie object for the specified

// document, with a specified name and optional attributes.

// Arguments:

//   document: The Document object for which the cookie is stored. Required.

//   name:     A string that specifies a name for the cookie. Required.

//   hours:    An optional number that specifies the number of hours from now

//             after which the cookie should expire.

//   path:     An optional string that specifies the cookie path attribute.

//   domain:   An optional string that specifies the cookie domain attribute.

//   secure:   An optional boolean value that, if true, requests a secure cookie.

//

function Cookie(document, name, hours, path, domain, secure)

{

    // All the predefined properties of this object begin with '$'

    // to distinguish them from other properties, which are the values to

    // be stored in the cookie

    this.$document = document;

    this.$name = name;

    if (hours)

        this.$expiration = new Date((new Date()).getTime(  ) + hours*3600000);

    else this.$expiration = null;

    if (path) this.$path = path; else this.$path = null;

    if (domain) this.$domain = domain; else this.$domain = null;

    if (secure) this.$secure = true; else this.$secure = false;

}



// This function is the store(  ) method of the Cookie object

Cookie.prototype.store = function (  ) {

    // First, loop through the properties of the Cookie object and

    // put together the value of the cookie. Since cookies use the

    // equals sign and semicolons as separators, we'll use colons

    // and ampersands for the individual state variables we store

    // within a single cookie value. Note that we escape the value

    // of each state variable, in case it contains punctuation or other

    // illegal characters.

    var cookieval = "";

    for(var prop in this) {

        // Ignore properties with names that begin with '$' and also methods

        if ((prop.charAt(0) == '$') || ((typeof this[prop]) == 'function'))

            continue;

        if (cookieval != "") cookieval += '&';

        cookieval += prop + ':' + escape(this[prop]);

    }



    // Now that we have the value of the cookie, put together the

    // complete cookie string, which includes the name and the various

    // attributes specified when the Cookie object was created

    var cookie = this.$name + '=' + cookieval;

    if (this.$expiration)

        cookie += '; expires=' + this.$expiration.toGMTString(  );

    if (this.$path) cookie += '; path=' + this.$path;

    if (this.$domain) cookie += '; domain=' + this.$domain;

    if (this.$secure) cookie += '; secure';



    // Now store the cookie by setting the magic Document.cookie property

    this.$document.cookie = cookie;

}



// This function is the load(  ) method of the Cookie object

Cookie.prototype.load = function(  ) {

    // First, get a list of all cookies that pertain to this document

    // We do this by reading the magic Document.cookie property

    var allcookies = this.$document.cookie;

    if (allcookies == "") return false;



    // Now extract just the named cookie from that list

    var start = allcookies.indexOf(this.$name + '=');

    if (start == -1) return false;   // Cookie not defined for this page

    start += this.$name.length + 1;  // Skip name and equals sign

    var end = allcookies.indexOf(';', start);

    if (end == -1) end = allcookies.length;

    var cookieval = allcookies.substring(start, end);



    // Now that we've extracted the value of the named cookie, we

    // must break that value down into individual state variable

    // names and values. The name/value pairs are separated from each

    // other by ampersands, and the individual names and values are

    // separated from each other by colons. We use the split(  ) method

    // to parse everything.

    var a = cookieval.split('&');    // Break it into an array of name/value pairs

    for(var i=0; i < a.length; i++)  // Break each pair into an array

        a[i] = a[i].split(':');



    // Now that we've parsed the cookie value, set all the names and values

    // of the state variables in this Cookie object. Note that we unescape(  )

    // the property value, because we called escape(  ) when we stored it.

    for(var i = 0; i < a.length; i++) {

        this[a[i][0]] = unescape(a[i][1]);

    }



    // We're done, so return the success code

    return true;

}



// This function is the remove(  ) method of the Cookie object

Cookie.prototype.remove = function(  ) {

    var cookie;

    cookie = this.$name + '=';

    if (this.$path) cookie += '; path=' + this.$path;

    if (this.$domain) cookie += '; domain=' + this.$domain;

    cookie += '; expires=Fri, 02-Jan-1970 00:00:00 GMT';



    this.$document.cookie = cookie;

}





//===================================================================

//  The previous code is the definition of the Cookie class.

//  The following code is a sample use of that class.

//===================================================================



// Create the cookie we'll use to save state for this web page.

// Since we're using the default path, this cookie will be accessible

// to all web pages in the same directory as this file or "below" it.

// Therefore, it should have a name that is unique among those pages.

// Note that we set the expiration to 10 days in the future.

var favoritesData = new Cookie(top.document, "autodesk_online_help_favorites", 24000);

function initalFavoritesLoad() {
        favoritesData.load();
        if (!favoritesData.load() || !favoritesData.urlString || !favoritesData.titleString) {
            favoritesData.urlString="";
            favoritesData.titleString="";
        }
    }

// First, try to read data stored in the cookie. If the cookie is not

// defined, or if it doesn't contain the data we need, then query the

// user for that data.

/*
favoritesData.load();
if (!favoritesData.load(  ) || !favoritesData.urlString || !favoritesData.titleString) {

}
*/



// Keep track of how many times this user has visited the page:

/*
if (visitordata.visits == null) visitordata.visits = 0;

visitordata.visits++;
*/



// Store the cookie values, even if they were already stored, so that the

// expiration date will be reset to 10 days from this most recent visit.

// Also, store them again to save the updated visits state variable.

//visitordata.store(  );



// Now we can use the state variables we read:

/*document.write('<font size="7" color="' + visitordata.color + '">' +

               'Welcome, ' + visitordata.name + '!' +

               '</font>' +

               '<p>You have visited ' + visitordata.visits + ' times.');*/


function addToFavorites()
{
	var url = top.content.location.pathname;
	var title = top.content.document.title;
    favoritesData.load();
    if (favoritesData.urlString.indexOf(url) == -1) {
        if (favoritesData.urlString) favoritesData.urlString += ";" + url;
        else favoritesData.urlString = url;
        if (favoritesData.titleString) favoritesData.titleString += ";" + title;
        else favoritesData.titleString = title;
        favoritesData.store();
        refreshFavoritesList();
    }
    refreshFavoritesPanel();
}

function refreshFavoritesPanel() {
    if(navigator.appName == "Netscape")
    {
        top.left_tab.document.getElementById('iframeFavoritesFrame').contentDocument.location.reload();
    }
    else if(navigator.appName == "Microsoft Internet Explorer")
    {
        top.left_tab.document.frames("iframeFavoritesFrame").document.location.reload();
    }
    else alert("Unsupported browser !");


}

function refreshFavoritesList()
{
    top.favoritesData.load();
    var urls = top.favoritesData.urlString.split(";");
    var titles = top.favoritesData.titleString.split(";");
    for (i=0; i< urls.length; i++) {
        favoritesList[i] = new Array();
        favoritesList[i][0] = urls[i];
        favoritesList[i][1] = titles[i];
    }
}

function synchronizeFavoriteData()
{
    var url = "";
    var titles = "";
    for (i=0; i< favoritesList.length; i++) {
        url += favoritesList[i][0];
        titles += favoritesList[i][1];
        if (i != (favoritesList.length - 1)) {
            url += ";";
            titles += ";";
        }
    }
    favoritesData.urlString = url;
    favoritesData.titleString = titles;
    favoritesData.store();
    refreshFavoritesPanel();
}



// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFImqn2oTF6Vc
// SIG // 66A5yeLVxIYLzYaLoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFCvvqN/+WJJwIISZMQXZ4CnQ+9mPMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAF
// SIG // tAGfD79cI9wgY9T8JrXROAtpkGLzB6UvK0irrUZ2fbur
// SIG // tKawG2lCul8zxu7xB9BoEWED0VIRKK6jBYwvI5CTqGu1
// SIG // /xuniayzXctj8RIRONaXTd50vRTRsldhrwAhw1pOa2Cp
// SIG // A0+Gd+w04/AgaHEJBKBo9b7YRkcwD2vCWeDOqKGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMzMDQz
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUPv0eNV/ujVhegcD/1/gK
// SIG // thfwPMAwDQYJKoZIhvcNAQEBBQAEgYCZLuPPv1Ks1oBG
// SIG // xAapOZIlLrpr2y/JU/OUaz4OVeGYfGUA1BC2KG36RPx+
// SIG // KTXsrsTo+YyusRR3ZKVP6PdTvHNh3CGzECjjri2rpMUC
// SIG // sgi/7hJScohy5agy2UfNoox4+hzNnSAR5A0HGuYSFVfN
// SIG // 5xIsuq6azMM+4SLWgUA0Xmx2fw==
// SIG // End signature block
